function Figure6B()
% Running this script produces the plot shown in Figure 6B and
% computes p-values.

%==========================================================================
% For data below, row 1 = CR9501; row 2 = 5C4; row 3 = ADI19425; row 4 = -IgG
mAb_names = {'CR9501','5C4','ADI-19425','-IgG'}; 

% C1 intensities per particle, PBS-treated sample:
C1p = [13998.1439 12314.1552 21202.8533 20243.3061
      23638.0617 13925.0251 21774.2185 25512.5272
      6057.5095 10301.8856 11214.1219 10714.8373
      4441.0266 1821.7234 2274.336 4242.0947];

% C1 intensities per particle, osmotically-swollen sample:
C1s = [35229.9127 46042.3113 76893.4593 49644.5634
      47348.1855 35436.4128 70893.1636 45992.8288
      14778.5691 23028.9442 47465.0458 21903.9989
      2180.4593 5095.1396 2834.8451 3573.878];

% mAb intensities per particle, PBS-treated sample:
Ap =  [10926.8551 11917.5811 11797.8999 9753.5362
       16750.8218 12812.7136 17086.4046 17061.7184
       11300.1753 8283.4071 9398.0979 10180.6674
       96.0848 93.873 103.6375 101.5099]; 
   
% mAb intensities per particle, osmotically-swollen sample:
As =  [9342.0705 11040.3929 9226.6803 8563.0097
       18010.4439 12577.1472 16414.6416 15490.7555
       7868.1082 7440.5325 10757.1467 11267.942
       66.7695 104.2535 81.1817 78.5585];
%==========================================================================

%==========================================================================
% Plot data for replicates and mean:
figure
for q = 1:4
  for k = 1:4
    plot([q+.2 q+1],([C1p(q,k),C1s(q,k)]),'Color',[0.7 0.7 0.7]); hold on;
  end
  plot([q+.2 q+1],[mean(C1p(q,:)),mean(C1s(q,:))],'k');
end
ylabel('C1q intensity per particle [AU]')
xticks([1.6 2.6 3.6 4.6]);
xticklabels(mAb_names);

figure
for q = 1:4
  for k = 1:4
    plot([q+.2 q+1],([Ap(q,k),As(q,k)]),'Color',[0.7 0.7 0.7]); hold on;
  end
  plot([q+.2 q+1],[mean(Ap(q,:)),mean(As(q,:))],'k');
end
ylim([0 3e4]);
ylabel('mAb intensity per particle [AU]')
xticks([1.6 2.6 3.6 4.6]);
xticklabels(mAb_names);
%==========================================================================

%==========================================================================
% Compute p-values using a paired-sample t-test:
[h,p] = ttest(C1p(1,:),C1s(1,:));
disp(['p-value CR9501 comparison (C1): ',num2str(p)]);
[h,p] = ttest(C1p(2,:),C1s(2,:));
disp(['p-value 5C4 comparison (C1): ',num2str(p)]);
[h,p] = ttest(C1p(3,:),C1s(3,:));
disp(['p-value ADI-19425 comparison (C1): ',num2str(p)]);
[h,p] = ttest(C1p(4,:),C1s(4,:));
disp(['p-value -IgG comparison (C1): ',num2str(p)]);

[h,p] = ttest(Ap(1,:),As(1,:));
disp(['p-value CR9501 comparison (mAb): ',num2str(p)]);
[h,p] = ttest(Ap(2,:),As(2,:));
disp(['p-value 5C4 comparison (mAb): ',num2str(p)]);
[h,p] = ttest(Ap(3,:),As(3,:));
disp(['p-value ADI-19425 comparison (mAb): ',num2str(p)]);
[h,p] = ttest(Ap(4,:),As(4,:));
disp(['p-value -IgG comparison (mAb): ',num2str(p)]);
%==========================================================================